// Generated by CoffeeScript 1.9.1
(function() {
  var Sync, root,
    hasProp = {}.hasOwnProperty,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Sync = Sync = {
    storage: chrome.storage.sync,
    doNotSync: ["settingsVersion", "previousVersion"],
    init: function() {
      chrome.storage.onChanged.addListener(function(changes, area) {
        return Sync.handleStorageUpdate(changes, area);
      });
      return this.fetchAsync();
    },
    fetchAsync: function() {
      return this.storage.get(null, (function(_this) {
        return function(items) {
          var key, results, value;
          if (!chrome.runtime.lastError) {
            results = [];
            for (key in items) {
              if (!hasProp.call(items, key)) continue;
              value = items[key];
              results.push(_this.storeAndPropagate(key, value));
            }
            return results;
          }
        };
      })(this));
    },
    handleStorageUpdate: function(changes, area) {
      var change, key, results;
      results = [];
      for (key in changes) {
        if (!hasProp.call(changes, key)) continue;
        change = changes[key];
        results.push(this.storeAndPropagate(key, change != null ? change.newValue : void 0));
      }
      return results;
    },
    storeAndPropagate: function(key, value) {
      var defaultValue, defaultValueJSON;
      if (!(key in Settings.defaults)) {
        return;
      }
      if (!this.shouldSyncKey(key)) {
        return;
      }
      if (value && key in localStorage && localStorage[key] === value) {
        return;
      }
      defaultValue = Settings.defaults[key];
      defaultValueJSON = JSON.stringify(defaultValue);
      if (value && value !== defaultValueJSON) {
        localStorage[key] = value;
        return Settings.performPostUpdateHook(key, JSON.parse(value));
      } else {
        if (key in localStorage) {
          delete localStorage[key];
        }
        return Settings.performPostUpdateHook(key, defaultValue);
      }
    },
    set: function(key, value) {
      var setting;
      if (this.shouldSyncKey(key)) {
        setting = {};
        setting[key] = value;
        return this.storage.set(setting);
      }
    },
    clear: function(key) {
      if (this.shouldSyncKey(key)) {
        return this.storage.remove(key);
      }
    },
    shouldSyncKey: function(key) {
      return indexOf.call(this.doNotSync, key) < 0;
    }
  };

}).call(this);
